# cPanel Upload Guide for Dashboard System

## 📋 Pre-Upload Checklist

### Files to Upload
Make sure you have all these files ready:
- `login.php`
- `dashboard.php`
- `applications.php`
- `international_exhibition.php`
- `regional_offices.php`
- `unauthorized.php`
- `setup.php`
- `includes/config.php`
- `assets/css/style.css`
- `assets/js/dashboard.js`
- `database/schema.sql`
- `database/sample_data.sql`
- `README.md`

## 🚀 Step 1: Upload Files to cPanel

### Method 1: Using cPanel File Manager
1. **Login to cPanel**
   - Go to your hosting provider's cPanel
   - Login with your credentials

2. **Open File Manager**
   - Find and click "File Manager" icon
   - Navigate to `public_html` folder (or your domain's root folder)

3. **Create Dashboard Folder**
   - Right-click in `public_html`
   - Select "Create Folder"
   - Name it `dashboard`

4. **Upload Files**
   - Enter the `dashboard` folder
   - Click "Upload" button
   - Select all your PHP files and upload them
   - Create `includes` folder and upload `config.php`
   - Create `assets` folder with `css` and `js` subfolders
   - Upload CSS and JS files to respective folders
   - Create `database` folder and upload SQL files
   - Create `uploads` folder (set permissions to 755)

### Method 2: Using FTP Client
1. **Connect via FTP**
   - Use FileZilla, WinSCP, or similar FTP client
   - Connect to your server using FTP credentials

2. **Upload Files**
   - Navigate to `public_html/dashboard/`
   - Upload all files maintaining folder structure

## 🗄️ Step 2: Create Database in cPanel

### Create MySQL Database
1. **Go to MySQL Databases**
   - In cPanel, find "MySQL Databases" section
   - Click on it

2. **Create Database**
   - Enter database name: `dashboard_db` (or your preferred name)
   - Click "Create Database"
   - Note down the full database name (usually `username_dashboard_db`)

3. **Create Database User**
   - Scroll down to "Add New User" section
   - Username: `dashboard_user` (or your preferred name)
   - Password: Create a strong password
   - Click "Create User"
   - Note down the full username (usually `username_dashboard_user`)

4. **Assign User to Database**
   - In "Add User To Database" section
   - Select your user and database
   - Click "Add"
   - Grant "ALL PRIVILEGES"
   - Click "Make Changes"

## ⚙️ Step 3: Configure Database Connection

### Update config.php
1. **Edit config.php file**
   - Open `includes/config.php` in cPanel File Manager
   - Find the Database class section

2. **Update Database Credentials**
```php
class Database {
    private $host = 'localhost';  // Usually localhost for cPanel
    private $db_name = 'your_full_database_name';  // e.g., username_dashboard_db
    private $username = 'your_full_username';      // e.g., username_dashboard_user
    private $password = 'your_password';           // The password you created
    private $conn;
    // ... rest of the code remains the same
}
```

### Example Configuration
```php
class Database {
    private $host = 'localhost';
    private $db_name = 'myhost_dashboard_db';
    private $username = 'myhost_dashboard_user';
    private $password = 'MySecurePassword123!';
    private $conn;
    // ... rest remains the same
}
```

## 📊 Step 4: Import Database Tables

### Method 1: Using phpMyAdmin
1. **Open phpMyAdmin**
   - In cPanel, find "phpMyAdmin" section
   - Click to open it

2. **Select Your Database**
   - Click on your database name in the left sidebar
   - If empty, you'll see "No tables found"

3. **Import SQL File**
   - Click "Import" tab
   - Click "Choose File" button
   - Select your `database/schema.sql` file
   - Click "Go" to import

4. **Import Sample Data (Optional)**
   - Click "Import" tab again
   - Select `database/sample_data.sql` file
   - Click "Go" to import

### Method 2: Using SQL Commands
1. **Open phpMyAdmin**
2. **Go to SQL Tab**
3. **Copy and Paste Schema**
   - Open `database/schema.sql` in a text editor
   - Copy all content
   - Paste into SQL textarea
   - Click "Go"

4. **Import Sample Data**
   - Repeat the process with `database/sample_data.sql`

## 🔧 Step 5: Set File Permissions

### Set Correct Permissions
1. **Set Folder Permissions**
   - `uploads/` folder: 755 or 777
   - `includes/` folder: 644
   - `assets/` folder: 644

2. **Set File Permissions**
   - All PHP files: 644
   - CSS/JS files: 644

### How to Set Permissions in cPanel
1. **Right-click on folder/file**
2. **Select "Change Permissions"**
3. **Set appropriate permissions**
4. **Click "Change Permissions"**

## 🌐 Step 6: Test Your Installation

### Access Your Dashboard
1. **Open Browser**
2. **Go to**: `https://yourdomain.com/dashboard/setup.php`
3. **Run Setup Script**
   - This will verify database connection
   - Create tables if needed
   - Show success message

4. **Access Login Page**
   - Go to: `https://yourdomain.com/dashboard/login.php`
   - Test with provided credentials

### Test Accounts
- **Super Admin**: superadmin@dashboard.com / password
- **Admin**: admin@dashboard.com / password
- **Textile Division**: textile@dashboard.com / password
- **Engineering Division**: engineering@dashboard.com / password
- **Agro Division**: agro@dashboard.com / password
- **Service Division**: service@dashboard.com / password
- **IMDD Division**: imdd@dashboard.com / password
- **WE Division**: we@dashboard.com / password

## 🔒 Step 7: Security Considerations

### Important Security Steps
1. **Change Default Passwords**
   - Update all test account passwords
   - Use strong, unique passwords

2. **Remove Setup File**
   - Delete `setup.php` after successful installation
   - This prevents unauthorized database access

3. **Secure Uploads Folder**
   - Add `.htaccess` file to `uploads/` folder:
```apache
# Prevent direct access to uploaded files
<Files "*.php">
    Order Deny,Allow
    Deny from all
</Files>
```

4. **Update Database Credentials**
   - Use strong database passwords
   - Consider using environment variables for production

## 🐛 Troubleshooting Common Issues

### Database Connection Issues
1. **Check Credentials**
   - Verify database name, username, password
   - Ensure user has proper permissions

2. **Check Host**
   - Try `localhost` first
   - If that fails, try your server's IP address

### File Permission Issues
1. **Uploads Folder**
   - Ensure `uploads/` folder has write permissions (755 or 777)
   - Check if PHP can create files

2. **PHP Files**
   - Ensure all PHP files have execute permissions (644)

### URL Issues
1. **Check URL Structure**
   - Ensure you're accessing correct path
   - Check if mod_rewrite is enabled (if using clean URLs)

## 📞 Support Information

### If You Need Help
1. **Check Error Logs**
   - Look in cPanel Error Logs
   - Check PHP error logs

2. **Verify Requirements**
   - PHP 7.4 or higher
   - MySQL 5.7 or higher
   - Sufficient disk space

3. **Contact Hosting Support**
   - If database issues persist
   - If file permission problems occur

## ✅ Final Checklist

- [ ] All files uploaded to correct locations
- [ ] Database created and user assigned
- [ ] Database connection configured
- [ ] Tables imported successfully
- [ ] File permissions set correctly
- [ ] Setup script runs without errors
- [ ] Login page accessible
- [ ] Test accounts working
- [ ] Application forms functional
- [ ] File uploads working
- [ ] Setup.php removed (after testing)

Your dashboard system should now be fully functional on cPanel!
