# Smart Dashboard System

A comprehensive role-based dashboard system built with PHP, HTML, CSS, JavaScript, and MySQL. This system provides different dashboard experiences for 4 user roles with proper access control and work submission management.

## Features

### 🔐 Role-Based Access Control
- **Super Admin**: Full system access, can view and manage all submissions
- **Admin**: Can view and manage all submissions from Division Role and Moderator users
- **Division Role**: Can create and manage their own work submissions
- **Moderator**: Can create and manage their own work submissions

### 📊 Dashboard Features
- Modern, responsive UI design
- Real-time submission tracking
- Status management (Pending, Approved, Rejected)
- Activity logging
- User authentication and session management

### 🛠️ Technical Stack
- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Security**: Password hashing, SQL injection prevention, XSS protection

## Installation

### Prerequisites
- XAMPP/WAMP/LAMP server
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web browser

### Setup Instructions

1. **Clone/Download the project**
   ```bash
   # Place files in your web server directory
   # For XAMPP: C:\xampp\htdocs\dashboard
   # For WAMP: C:\wamp64\www\dashboard
   ```

2. **Database Setup**
   ```sql
   -- Import the database schema
   mysql -u root -p < database/schema.sql
   
   -- Import sample data (optional)
   mysql -u root -p < database/sample_data.sql
   ```

3. **Configure Database Connection**
   - Edit `includes/config.php` if needed
   - Default settings work with XAMPP/WAMP default MySQL configuration

4. **Start Web Server**
   - Start Apache and MySQL services
   - Navigate to `http://localhost/dashboard`

## Default Login Credentials

| Role | Email | Password |
|------|-------|----------|
| Super Admin | superadmin@dashboard.com | password |
| Admin | admin@dashboard.com | password |
| Division Role | division@dashboard.com | password |
| Moderator | moderator@dashboard.com | password |

## Project Structure

```
dashboard/
├── assets/
│   ├── css/
│   │   └── style.css          # Main stylesheet
│   └── js/
│       └── dashboard.js       # JavaScript functionality
├── database/
│   ├── schema.sql             # Database schema
│   └── sample_data.sql        # Sample data
├── includes/
│   └── config.php             # Database config and classes
├── dashboard.php              # Main dashboard page
├── login.php                  # Login page
├── unauthorized.php           # Access denied page
└── README.md                  # This file
```

## User Roles & Permissions

### Super Admin
- ✅ View all submissions from all users
- ✅ Approve/reject any submission
- ✅ Access to all system features
- ✅ View activity logs
- ✅ Manage user accounts (future feature)

### Admin
- ✅ View all submissions from Division Role and Moderator users
- ✅ Approve/reject submissions
- ✅ Access admin panel
- ✅ View submission statistics
- ❌ Cannot access Super Admin features

### Division Role
- ✅ Create new work submissions
- ✅ View own submissions
- ✅ Update own submissions (future feature)
- ❌ Cannot view other users' submissions
- ❌ Cannot approve/reject submissions

### Moderator
- ✅ Create new work submissions
- ✅ View own submissions
- ✅ Update own submissions (future feature)
- ❌ Cannot view other users' submissions
- ❌ Cannot approve/reject submissions

## Work Submission System

### Submission Types
- **Document**: Text documents, PDFs, Word files
- **Image**: Images, graphics, visual content
- **Report**: Analytical reports, data summaries
- **Other**: Any other type of work

### Submission Status
- **Pending**: Awaiting review by Admin/Super Admin
- **Approved**: Accepted and approved
- **Rejected**: Declined with review notes

## Security Features

- Password hashing using PHP's `password_hash()`
- SQL injection prevention with prepared statements
- XSS protection with `htmlspecialchars()`
- Session management and timeout
- Role-based access control
- Activity logging for audit trails

## Customization

### Adding New User Roles
1. Update the `role` ENUM in the database schema
2. Modify role hierarchy in `includes/config.php`
3. Add role-specific dashboard sections
4. Update CSS for role-specific styling

### Styling Customization
- Main stylesheet: `assets/css/style.css`
- Color scheme can be modified in CSS variables
- Responsive design included for mobile devices

### Database Configuration
- Edit `includes/config.php` for database settings
- Modify connection parameters as needed
- Ensure proper MySQL user permissions

## Browser Support

- Chrome 70+
- Firefox 65+
- Safari 12+
- Edge 79+
- Mobile browsers (iOS Safari, Chrome Mobile)

## Troubleshooting

### Common Issues

1. **Database Connection Error**
   - Check MySQL service is running
   - Verify database credentials in `config.php`
   - Ensure database exists and is accessible

2. **Login Not Working**
   - Verify user exists in database
   - Check password hashing compatibility
   - Clear browser cache and cookies

3. **Permission Denied Errors**
   - Check file permissions on web server
   - Ensure proper directory structure
   - Verify Apache/nginx configuration

4. **CSS/JS Not Loading**
   - Check file paths in HTML
   - Verify web server document root
   - Clear browser cache

### Debug Mode
To enable debug mode, add this to the top of `includes/config.php`:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## Future Enhancements

- [ ] File upload functionality
- [ ] Email notifications
- [ ] Advanced reporting and analytics
- [ ] User management interface
- [ ] API endpoints for mobile apps
- [ ] Two-factor authentication
- [ ] Advanced search and filtering
- [ ] Export functionality (PDF, Excel)

## License

This project is open source and available under the MIT License.

## Support

For support and questions, please refer to the documentation or create an issue in the project repository.
