# 🚀 Your cPanel Deployment Checklist

## ✅ Database Configuration Updated
Your database credentials have been configured:
- **Database Name**: `dashboardtdapgov_dashboard_db`
- **Username**: `dashboardtdapgov_dashboard_user`
- **Password**: `iS^G0ydT#PX8c[OT`
- **Host**: `localhost`

## 📋 Step-by-Step Deployment

### 1. Upload Files to cPanel
```
📁 public_html/dashboard/
├── 📄 login.php
├── 📄 dashboard.php
├── 📄 applications.php
├── 📄 international_exhibition.php
├── 📄 regional_offices.php
├── 📄 unauthorized.php
├── 📄 cpanel_setup.php
├── 📁 includes/
│   └── 📄 config.php (✅ Updated with your credentials)
├── 📁 assets/
│   ├── 📁 css/
│   │   └── 📄 style.css
│   └── 📁 js/
│       └── 📄 dashboard.js
├── 📁 database/
│   └── 📄 cpanel_tables.sql
└── 📁 uploads/ (Create this folder, set permissions to 755)
```

### 2. Run Database Setup
1. **Go to**: `https://yourdomain.com/dashboard/cpanel_setup.php`
2. **Click through the setup process**
3. **Verify all tables are created successfully**

### 3. Test Login
1. **Go to**: `https://yourdomain.com/dashboard/login.php`
2. **Test with these accounts**:

#### 🔐 Test Accounts
| Role | Email | Password |
|------|-------|----------|
| Super Admin | superadmin@dashboard.com | password |
| Admin | admin@dashboard.com | password |
| Moderator | moderator@dashboard.com | password |
| **Textile Division** | textile@dashboard.com | password |
| **Engineering Division** | engineering@dashboard.com | password |
| **Agro Division** | agro@dashboard.com | password |
| **Service Division** | service@dashboard.com | password |
| **IMDD Division** | imdd@dashboard.com | password |
| **WE Division** | we@dashboard.com | password |

### 4. Verify Features
- ✅ Login with different roles
- ✅ Create International Exhibition applications
- ✅ Create Regional Offices applications
- ✅ Upload CSV/PDF files
- ✅ Admin can see all applications
- ✅ Division users only see their own applications

### 5. Security Steps (IMPORTANT!)
After testing:
1. **Delete** `cpanel_setup.php` for security
2. **Change** all default passwords
3. **Add** `.htaccess` to `uploads/` folder:
```apache
# Prevent direct access to uploaded files
<Files "*.php">
    Order Deny,Allow
    Deny from all
</Files>
```

## 🎯 Your Dashboard Features

### 6 Divisions Available:
1. **Textile** (TXT) - Textile and Fashion Division
2. **Engineering** (ENG) - Engineering and Technology Division
3. **Agro** (AGRO) - Agriculture and Food Division
4. **Service** (SVC) - Service Industry Division
5. **IMDD** (IMDD) - International Marketing and Development Division
6. **WE** (WE) - Women Empowerment Division

### Application Forms:
1. **International Exhibition Form**
   - Serial No, Activity/Achievement, Date
   - Brief Description, Objective, Impact/Significance/Outcome

2. **Regional Offices Form**
   - Country selection, Produce
   - Date Wise, Year Wise
   - File Upload (CSV/PDF)

### Access Control:
- **Division Role**: Can only see their own division's applications
- **Admin & Super Admin**: Can see all divisions' applications
- **Moderator**: Can see all divisions' applications

## 🔧 Troubleshooting

### If Database Connection Fails:
1. Check if database exists in cPanel
2. Verify user has ALL PRIVILEGES on database
3. Try different host (sometimes it's not 'localhost')

### If File Uploads Don't Work:
1. Check `uploads/` folder permissions (755)
2. Verify PHP file upload settings
3. Check disk space

### If Pages Don't Load:
1. Check file permissions (644 for PHP files)
2. Verify all files uploaded correctly
3. Check PHP error logs in cPanel

## 📞 Support
If you encounter any issues:
1. Check cPanel Error Logs
2. Verify PHP version (7.4+ required)
3. Ensure MySQL version (5.7+ required)

Your dashboard system is now ready for production use! 🎉
