<?php
// cPanel Database Setup Script
// This script helps you set up the database tables on cPanel

// Database configuration - UPDATED FOR YOUR cPanel
$db_config = [
    'host' => 'localhost',                           // Usually localhost for cPanel
    'dbname' => 'dashboardtdapgov_dashboard_db',     // Your actual database name
    'username' => 'dashboardtdapgov_dashboard_user', // Your actual username
    'password' => 'iS^G0ydT#PX8c[OT'                // Your actual password
];

echo "<h1>Dashboard System - cPanel Database Setup</h1>";
echo "<div style='max-width: 800px; margin: 0 auto; font-family: Arial, sans-serif;'>";

// Configuration is already updated with your cPanel credentials
echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
echo "<h3>✅ Configuration Ready</h3>";
echo "<p>Database configuration has been updated with your cPanel credentials:</p>";
echo "<ul>";
echo "<li><strong>Database:</strong> dashboardtdapgov_dashboard_db</li>";
echo "<li><strong>Username:</strong> dashboardtdapgov_dashboard_user</li>";
echo "<li><strong>Host:</strong> localhost</li>";
echo "</ul>";
echo "</div>";

try {
    // Test database connection
    $pdo = new PDO("mysql:host={$db_config['host']};dbname={$db_config['dbname']}", 
                   $db_config['username'], 
                   $db_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "✅ Database connection successful!";
    echo "</div>";
    
    // Check if tables already exist
    $tables_check = $pdo->query("SHOW TABLES LIKE 'users'")->rowCount();
    
    if ($tables_check > 0) {
        echo "<div style='background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
        echo "<h3>⚠️ Tables Already Exist</h3>";
        echo "<p>It appears the database tables already exist. Do you want to:</p>";
        echo "<p><a href='?action=recreate' style='background: #dc3545; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Recreate All Tables</a></p>";
        echo "<p><strong>Warning:</strong> This will delete all existing data!</p>";
        echo "</div>";
        
        if (isset($_GET['action']) && $_GET['action'] === 'recreate') {
            // Drop existing tables
            $drop_tables = [
                'DROP TABLE IF EXISTS activity_logs',
                'DROP TABLE IF EXISTS work_submissions',
                'DROP TABLE IF EXISTS regional_offices_data',
                'DROP TABLE IF EXISTS international_exhibition_data',
                'DROP TABLE IF EXISTS application_forms',
                'DROP TABLE IF EXISTS users',
                'DROP TABLE IF EXISTS divisions'
            ];
            
            foreach ($drop_tables as $sql) {
                $pdo->exec($sql);
            }
            
            echo "<div style='background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
            echo "✅ Existing tables dropped successfully!";
            echo "</div>";
        } else {
            echo "<div style='background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
            echo "<h3>📊 Current Database Status</h3>";
            
            // Show existing tables
            $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
            echo "<p><strong>Existing Tables:</strong></p>";
            echo "<ul>";
            foreach ($tables as $table) {
                echo "<li>$table</li>";
            }
            echo "</ul>";
            
            // Show user count
            try {
                $user_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
                echo "<p><strong>Total Users:</strong> $user_count</p>";
            } catch (Exception $e) {
                echo "<p>Could not count users</p>";
            }
            
            echo "</div>";
            echo "</div>";
            exit();
        }
    }
    
    // Create tables
    echo "<h3>📊 Creating Database Tables...</h3>";
    
    // Read schema file
    if (file_exists('database/schema.sql')) {
        $schema = file_get_contents('database/schema.sql');
        $statements = explode(';', $schema);
        
        $created_tables = [];
        foreach ($statements as $statement) {
            $statement = trim($statement);
            if (!empty($statement) && !preg_match('/^(CREATE DATABASE|USE)/i', $statement)) {
                try {
                    $pdo->exec($statement);
                    
                    // Extract table name for logging
                    if (preg_match('/CREATE TABLE\s+(\w+)/i', $statement, $matches)) {
                        $created_tables[] = $matches[1];
                    }
                } catch (PDOException $e) {
                    echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; margin: 10px 0;'>";
                    echo "❌ Error creating table: " . $e->getMessage();
                    echo "</div>";
                }
            }
        }
        
        echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
        echo "✅ Tables created successfully!";
        echo "<ul>";
        foreach ($created_tables as $table) {
            echo "<li>$table</li>";
        }
        echo "</ul>";
        echo "</div>";
    } else {
        echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
        echo "❌ Schema file not found! Please ensure database/schema.sql exists.";
        echo "</div>";
    }
    
    // Insert sample data
    echo "<h3>📝 Inserting Sample Data...</h3>";
    
    if (file_exists('database/sample_data.sql')) {
        $sampleData = file_get_contents('database/sample_data.sql');
        $statements = explode(';', $sampleData);
        
        $inserted_records = 0;
        foreach ($statements as $statement) {
            $statement = trim($statement);
            if (!empty($statement) && !preg_match('/^(CREATE DATABASE|USE)/i', $statement)) {
                try {
                    $pdo->exec($statement);
                    $inserted_records++;
                } catch (PDOException $e) {
                    echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; margin: 10px 0;'>";
                    echo "❌ Error inserting data: " . $e->getMessage();
                    echo "</div>";
                }
            }
        }
        
        echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
        echo "✅ Sample data inserted successfully! ($inserted_records operations completed)";
        echo "</div>";
    }
    
    // Create uploads directory
    if (!file_exists('uploads')) {
        mkdir('uploads', 0755, true);
        echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
        echo "✅ Uploads directory created successfully!";
        echo "</div>";
    }
    
    // Final verification
    echo "<h3>🔍 Verification</h3>";
    
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "<p><strong>Created Tables:</strong></p>";
    echo "<ul>";
    foreach ($tables as $table) {
        echo "<li>$table</li>";
    }
    echo "</ul>";
    
    // Count records
    try {
        $user_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
        $division_count = $pdo->query("SELECT COUNT(*) FROM divisions")->fetchColumn();
        $application_count = $pdo->query("SELECT COUNT(*) FROM application_forms")->fetchColumn();
        
        echo "<p><strong>Records Created:</strong></p>";
        echo "<ul>";
        echo "<li>Users: $user_count</li>";
        echo "<li>Divisions: $division_count</li>";
        echo "<li>Applications: $application_count</li>";
        echo "</ul>";
    } catch (Exception $e) {
        echo "<p>Could not count records</p>";
    }
    
    echo "<div style='background: #d1ecf1; color: #0c5460; padding: 20px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3>🎉 Setup Complete!</h3>";
    echo "<p>Your dashboard system is now ready to use.</p>";
    echo "<p><a href='login.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Go to Login Page</a></p>";
    echo "</div>";
    
    echo "<h3>🔐 Test Accounts</h3>";
    echo "<div style='background: #f8f9fa; padding: 15px; border-radius: 5px;'>";
    echo "<ul>";
    echo "<li><strong>Super Admin:</strong> superadmin@dashboard.com / password</li>";
    echo "<li><strong>Admin:</strong> admin@dashboard.com / password</li>";
    echo "<li><strong>Moderator:</strong> moderator@dashboard.com / password</li>";
    echo "<li><strong>Textile Division:</strong> textile@dashboard.com / password</li>";
    echo "<li><strong>Engineering Division:</strong> engineering@dashboard.com / password</li>";
    echo "<li><strong>Agro Division:</strong> agro@dashboard.com / password</li>";
    echo "<li><strong>Service Division:</strong> service@dashboard.com / password</li>";
    echo "<li><strong>IMDD Division:</strong> imdd@dashboard.com / password</li>";
    echo "<li><strong>WE Division:</strong> we@dashboard.com / password</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<div style='background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3>⚠️ Important Security Note</h3>";
    echo "<p>After testing, please:</p>";
    echo "<ul>";
    echo "<li>Delete this setup file for security</li>";
    echo "<li>Change all default passwords</li>";
    echo "<li>Update database credentials in includes/config.php</li>";
    echo "</ul>";
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3>❌ Database Connection Failed</h3>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<p>Please check your database configuration and try again.</p>";
    echo "</div>";
    
    echo "<h3>Common Issues:</h3>";
    echo "<ul>";
    echo "<li>Incorrect database name, username, or password</li>";
    echo "<li>Database user doesn't have proper permissions</li>";
    echo "<li>Wrong host address (try 'localhost' or your server IP)</li>";
    echo "<li>Database doesn't exist</li>";
    echo "</ul>";
}

echo "</div>";
?>
