-- Additional Sample Data for Testing
USE dashboard_db;

-- Insert more sample users for testing
INSERT INTO users (email, password, role, full_name) VALUES
('admin2@dashboard.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin', 'Secondary Admin'),
('division2@dashboard.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Division Role', 'Division Lead'),
('moderator2@dashboard.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Moderator', 'Content Reviewer');

-- Insert more sample work submissions
INSERT INTO work_submissions (user_id, title, description, submission_type, status) VALUES
(3, 'Q2 Performance Analysis', 'Detailed analysis of Q2 performance metrics and KPIs', 'report', 'pending'),
(3, 'Project Roadmap 2024', 'Comprehensive roadmap for upcoming projects', 'document', 'approved'),
(4, 'Social Media Content Review', 'Review of social media content for brand consistency', 'document', 'pending'),
(4, 'User Experience Report', 'Analysis of user feedback and experience improvements', 'report', 'approved'),
(5, 'Marketing Strategy Document', 'Updated marketing strategy for next quarter', 'document', 'pending'),
(5, 'Team Performance Metrics', 'Monthly team performance evaluation', 'report', 'pending'),
(6, 'Content Guidelines Update', 'Updated content creation guidelines', 'document', 'approved'),
(6, 'Community Management Report', 'Monthly community engagement report', 'report', 'pending');

-- Insert sample activity logs
INSERT INTO activity_logs (user_id, action, description, ip_address) VALUES
(1, 'login', 'Super Admin logged in', '192.168.1.100'),
(2, 'login', 'Admin logged in', '192.168.1.101'),
(3, 'submission_created', 'Created work submission: Q2 Performance Analysis', '192.168.1.102'),
(4, 'submission_created', 'Created work submission: Social Media Content Review', '192.168.1.103'),
(2, 'status_updated', 'Updated submission status to: approved', '192.168.1.101'),
(1, 'status_updated', 'Updated submission status to: rejected', '192.168.1.100');
