<?php
require_once 'includes/config.php';

$error_message = '';

if ($_POST) {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    $database = new Database();
    $db = $database->getConnection();
    $userAuth = new UserAuth($db);
    
    $user = $userAuth->login($email, $password);
    
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_email'] = $user['email'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['user_name'] = $user['full_name'];
        $_SESSION['division_id'] = $user['division_id'];
        
        header('Location: dashboard.php');
        exit();
    } else {
        $error_message = 'Invalid email or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Login</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-body">
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <h1>Dashboard Login</h1>
                <p>Sign in to access your dashboard</p>
            </div>
            
            <?php if ($error_message): ?>
                <div class="alert alert-error"><?php echo $error_message; ?></div>
            <?php endif; ?>
            
            <form method="POST" class="login-form">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" required 
                           placeholder="Enter your email" value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
                </div>
                
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" required 
                           placeholder="Enter your password">
                </div>
                
                <button type="submit" class="btn btn-primary btn-full">Sign In</button>
            </form>
            
            <div class="login-footer">
                <h3>Test Accounts:</h3>
                <div class="test-accounts">
                    <div class="account-item">
                        <strong>Super Admin:</strong> superadmin@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>Admin:</strong> admin@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>Moderator:</strong> moderator@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>Textile Division:</strong> textile@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>Engineering Division:</strong> engineering@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>Agro Division:</strong> agro@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>Service Division:</strong> service@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>IMDD Division:</strong> imdd@dashboard.com / password
                    </div>
                    <div class="account-item">
                        <strong>WE Division:</strong> we@dashboard.com / password
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
