<?php
// Database setup script - Run this to initialize the database
require_once 'includes/config.php';

echo "<h2>Database Setup Script</h2>";

try {
    // Create database if it doesn't exist
    $pdo = new PDO("mysql:host=localhost", "root", "");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $pdo->exec("CREATE DATABASE IF NOT EXISTS dashboard_db");
    echo "<p>✅ Database 'dashboard_db' created successfully</p>";
    
    // Connect to the created database
    $pdo = new PDO("mysql:host=localhost;dbname=dashboard_db", "root", "");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Read and execute schema
    $schema = file_get_contents('database/schema.sql');
    $statements = explode(';', $schema);
    
    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement)) {
            $pdo->exec($statement);
        }
    }
    
    echo "<p>✅ Database schema created successfully</p>";
    
    // Check if sample data exists
    if (file_exists('database/sample_data.sql')) {
        $sampleData = file_get_contents('database/sample_data.sql');
        $statements = explode(';', $sampleData);
        
        foreach ($statements as $statement) {
            $statement = trim($statement);
            if (!empty($statement)) {
                $pdo->exec($statement);
            }
        }
        
        echo "<p>✅ Sample data inserted successfully</p>";
    }
    
    // Create uploads directory if it doesn't exist
    if (!file_exists('uploads')) {
        mkdir('uploads', 0777, true);
        echo "<p>✅ Uploads directory created successfully</p>";
    }
    
    echo "<h3>Setup Complete!</h3>";
    echo "<p>You can now <a href='login.php'>login to the dashboard</a></p>";
    echo "<h4>Test Accounts:</h4>";
    echo "<ul>";
    echo "<li><strong>Super Admin:</strong> superadmin@dashboard.com / password</li>";
    echo "<li><strong>Admin:</strong> admin@dashboard.com / password</li>";
    echo "<li><strong>Moderator:</strong> moderator@dashboard.com / password</li>";
    echo "<li><strong>Textile Division:</strong> textile@dashboard.com / password</li>";
    echo "<li><strong>Engineering Division:</strong> engineering@dashboard.com / password</li>";
    echo "<li><strong>Agro Division:</strong> agro@dashboard.com / password</li>";
    echo "<li><strong>Service Division:</strong> service@dashboard.com / password</li>";
    echo "<li><strong>IMDD Division:</strong> imdd@dashboard.com / password</li>";
    echo "<li><strong>WE Division:</strong> we@dashboard.com / password</li>";
    echo "</ul>";
    
    echo "<h4>Features:</h4>";
    echo "<ul>";
    echo "<li>✅ 6 Divisions: Textile, Engineering, Agro, Service, IMDD, WE</li>";
    echo "<li>✅ International Exhibition Form with all required fields</li>";
    echo "<li>✅ Regional Offices Form with country, produce, date/year filters</li>";
    echo "<li>✅ File upload support for CSV and PDF files</li>";
    echo "<li>✅ Division-based access control</li>";
    echo "<li>✅ Admin panel to view all applications</li>";
    echo "<li>✅ Role-based permissions</li>";
    echo "</ul>";
    
} catch (PDOException $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
    echo "<p>Please check your MySQL connection settings in includes/config.php</p>";
}
?>