<?php
require_once 'includes/config.php';

// Redirect to login if not authenticated
requireLogin();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unauthorized Access</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="unauthorized-body">
    <div class="unauthorized-container">
        <div class="unauthorized-card">
            <div class="unauthorized-icon">🚫</div>
            <h1>Access Denied</h1>
            <p>You don't have permission to access this page.</p>
            <p>Your current role: <strong><?php echo htmlspecialchars($_SESSION['user_role']); ?></strong></p>
            <div class="unauthorized-actions">
                <a href="dashboard.php" class="btn btn-primary">Go to Dashboard</a>
                <a href="login.php" class="btn btn-secondary">Login as Different User</a>
            </div>
        </div>
    </div>
</body>
</html>
